package gov.va.med.mhv.sm.admin.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import gov.va.med.mhv.sm.admin.jpa.model.SMPatient;
import gov.va.med.mhv.sm.admin.jpa.model.TriageGroup;
import gov.va.med.mhv.sm.admin.jpa.model.TriageRelation;
import gov.va.med.mhv.sm.admin.jpa.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.admin.jpa.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.admin.exception.SMApiException;
import gov.va.med.mhv.sm.admin.dto.TriageGroupDTO;
import gov.va.med.mhv.sm.admin.dto.SMPatientDTO;
import gov.va.med.mhv.sm.admin.dto.PatientBlockedFacilityDTO;
import gov.va.med.mhv.sm.admin.dto.PatientBlockedTriageGroupDTO;
import gov.va.med.mhv.sm.admin.data.enums.SMErrorEnum;
import gov.va.med.mhv.sm.admin.converter.SMPatientConverter;
import gov.va.med.mhv.sm.admin.converter.TriageGroupConverter;
import gov.va.med.mhv.sm.admin.converter.PatientBlockedFacilityConverter;
import gov.va.med.mhv.sm.admin.converter.PatientBlockedTriageGroupConverter;
import gov.va.med.mhv.sm.admin.service.util.ResponseCodeUtil;

import gov.va.med.mhv.sm.admin.jpa.repository.SMUserRepository;
import gov.va.med.mhv.sm.admin.jpa.repository.TriageRelationRepository;
import gov.va.med.mhv.sm.admin.jpa.repository.PatientBlockedTriageGroupRepository;
import gov.va.med.mhv.sm.admin.jpa.repository.PatientBlockedFacilityRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;

@Path("/patients")
@Service("patientTGService")
@Component
public class PatientTGService { 

    @Autowired
    private TriageRelationRepository triageRelationRepository;
    
    @Autowired
    PatientBlockedTriageGroupRepository patientBlockedTriageGroupRepository;
    
    @Autowired
    PatientBlockedFacilityRepository patientBlockedFacilityRepository;
    
    @Autowired
    private SMUserRepository smUserRepository;
    
	private static final Log log = LogFactory.getLog(PatientTGService.class);

	@GET
	@Operation(summary = "Get Patients By TriageGroup")
	@ApiResponses(value = {
	        @ApiResponse(responseCode = "200", 
	        			content = @Content(mediaType = "application/json", 
	        			array = @ArraySchema(schema = @Schema(implementation = TriageRelation.class)))),
			@ApiResponse(responseCode = "404", description = "Triage groups are not found",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class))),
			@ApiResponse(responseCode = "500", description = "UnExpected Error Occurred",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class)))
	})	
	public List<TriageGroupDTO> getPatientsByTriageGroup(@QueryParam("triageGroupId") Long triageGroupId) throws SMApiException {
		
		List<TriageRelation> triageRelationPatientList = null;
		List<TriageGroupDTO> triageGroupDTOList = null;
		
		List<TriageGroup> triageGroupList = null;
		
		try 
		{	if (triageGroupId != null) {
				triageRelationPatientList = triageRelationRepository.getPatientsByTriageGroup(triageGroupId);
				if(triageRelationPatientList != null) {
					for (TriageRelation triageRelation : triageRelationPatientList) {
						if(triageRelation != null) {
							triageGroupList.add(triageRelation.getTriageGroup());
						}
					}
				}
			}else {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
		
			if(triageGroupList != null && triageGroupList.size()>0) {
				triageGroupDTOList = TriageGroupConverter.convertList(triageGroupList);
			}else {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
		
		} catch (Exception e) {
			log.error(e);
			throw new SMApiException(SMErrorEnum.UNKNOWN_EXCEPTION.getErrorMessage(), ResponseCodeUtil.STATUS_INTERNAL_SERVER_ERROR,e);
		}
		return triageGroupDTOList;
	}
	
	@GET
	@Path("/smpatients")	
	@Operation(summary = "Get Patients By Name and NSSN")
	@ApiResponses(value = {
	        @ApiResponse(responseCode = "200", 
	        			content = @Content(mediaType = "application/json", 
	        			array = @ArraySchema(schema = @Schema(implementation = SMPatient.class)))),
			@ApiResponse(responseCode = "404", description = "Patients are not found",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class))),
			@ApiResponse(responseCode = "500", description = "UnExpected Error Occurred",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class)))
	})	
	public List<SMPatientDTO> getPatientsByNameAndNSSN(@QueryParam("firstName") String firstName,
													@QueryParam("lastName") String lastName, 
													@QueryParam("nssn") String nssn, 
													@QueryParam("facilityId") Long facilityId) throws SMApiException {
		List<SMPatient> patientList = null;
		
		List<SMPatientDTO> patientDTOList = null;
		try 
		{
			if(firstName != null && lastName != null && nssn != null && facilityId != null)
				patientList = smUserRepository.getPatientByNameAndNSSN(firstName, lastName, nssn,facilityId);
			
			if(patientList != null && patientList.size()>0) {
				patientDTOList = SMPatientConverter.convertList(patientList);
			}else {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
			
		} catch (Exception e) {
			log.error(e);
			throw new SMApiException(SMErrorEnum.UNKNOWN_EXCEPTION.getErrorMessage(), ResponseCodeUtil.STATUS_INTERNAL_SERVER_ERROR,e);
		}
		return patientDTOList;
	}
	
	@GET
	@Path("/facililities")	
	@Operation(summary = "Get Blocked Facility Patients Details  By Station")
	@ApiResponses(value = {
	        @ApiResponse(responseCode = "200", 
	        			content = @Content(mediaType = "application/json", 
	        			array = @ArraySchema(schema = @Schema(implementation = PatientBlockedFacility.class)))),
			@ApiResponse(responseCode = "404", description = "Blocked Patients are not found",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class))),
			@ApiResponse(responseCode = "500", description = "UnExpected Error Occurred",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class)))
	})	
	public List<PatientBlockedFacilityDTO> getBlockedFacilityPatientsDetailsByStation(@QueryParam("facilityId") Long facilityId) throws SMApiException {
		List<PatientBlockedFacility> patientList = null;
		List<PatientBlockedFacilityDTO> patientDTOList = null;
		
		try 
		{ 
			if(facilityId != null)
				patientList = patientBlockedFacilityRepository.getBlockedFacilityPatientsDetailsByStation(facilityId);
			
			if(patientList != null && patientList.size()>0) {
				patientDTOList = PatientBlockedFacilityConverter.convertList(patientList);
			}else {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
			
		} catch (Exception e) {
			log.error(e);
			throw new SMApiException(SMErrorEnum.UNKNOWN_EXCEPTION.getErrorMessage(), ResponseCodeUtil.STATUS_INTERNAL_SERVER_ERROR,e);
		}
		return patientDTOList;
	}
	
	@GET
	@Path("/triagegroups")	
	@Operation(summary = "Get Blocked Patients Details  By Triage Group")
	@ApiResponses(value = {
	        @ApiResponse(responseCode = "200", 
	        			content = @Content(mediaType = "application/json", 
	        			array = @ArraySchema(schema = @Schema(implementation = PatientBlockedTriageGroup.class)))),
			@ApiResponse(responseCode = "404", description = "Blocked Patients are not found",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class))),
			@ApiResponse(responseCode = "500", description = "UnExpected Error Occurred",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class)))
	})			
	public List<PatientBlockedTriageGroupDTO> getBlockedPatientsDetailsByTriageGroupId(@QueryParam("triageGroupId") Long triageGroupId) throws SMApiException {
		List<PatientBlockedTriageGroup> patientList = null;
		List<PatientBlockedTriageGroupDTO> patientDTOList = null;
		try 
		{ 
			if(triageGroupId != null)
				patientList = patientBlockedTriageGroupRepository.getBlockedPatientsDetailsByTriageGroupId(triageGroupId);
			
			if(patientList != null && patientList.size()>0) {
				patientDTOList = PatientBlockedTriageGroupConverter.convertList(patientList);
			}else {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
			
		} catch (Exception e) {
			log.error(e);
			throw new SMApiException(SMErrorEnum.UNKNOWN_EXCEPTION.getErrorMessage(), ResponseCodeUtil.STATUS_INTERNAL_SERVER_ERROR,e);
		}
		return patientDTOList;
	}
	
	
}
